#!/usr/bin/python

# This imports are needed to make the file executeable

import matplotlib
matplotlib.use("TkAgg")
import getpass
import os
import tkFileDialog
import avlogMaths as av
import Tkinter as tk
import tkMessageBox as mb
import FileDialog

FRAME = tk.Tk()
TEXTFIELD = None
PATH = None

SEQUENCE_SRTFILE = "Sequenzen.srt"


class ParentGUI():
    """
    This class creates the main UI which is shown to the user.
    """
    def __init__(self, parentWindow):
        # the object name is self, in this case "mainWindow" and parentWindow is the given parameter in this object "FRAME"
        self.parentWindow = parentWindow
        self.parentWindow.title("av_log")
        self.parentWindow.resizable(tk.FALSE, tk.FALSE)
        self.parentWindow.geometry("510x250")

        # Create labels to say what should be done
        self.labelSelect = tk.Label(self.parentWindow, font=("Arial", 13), 
                                    text = "Please select a folder:")
        self.labelSelect.place(x=20, y=20)

        self.labelPath = tk.Label(self.parentWindow, text = "Path:")
        self.labelPath.place(x=20, y=72)

        self.labelMinute = tk.Label(self.parentWindow, text = "New line from (in min):")
        self.labelMinute.place(x=20, y=120)

        # Create a textfield and place it on the UI
        self.textfieldPath = tk.Entry(self.parentWindow, bd=3)
        self.textfieldPath.place(x=60, y=72, width=360)

        self.textfieldMinute = tk.Entry(self.parentWindow, bd=3)
        self.textfieldMinute.place(x=160, y=120, width=40)

        # Create buttons to open a file, to continue (export graphic) and for cancel
        self.buttonOpen = tk.Button(self.parentWindow, text = "Open", bd=3, command=readPathOfFiles)
        self.buttonOpen.place(x=430, y=70, width=65)

        self.buttonOk = tk.Button(self.parentWindow, text = "Ok", bd=3, command=readSubtitleFiles)
        self.buttonOk.place(x=350, y=200, width=65)

        self.buttonCancel = tk.Button(self.parentWindow, text = "Cancel", bd=3, command=self.showDialog)
        self.buttonCancel.place(x=430, y=200, width=65)

        # Show dialog if the user press the default "X" button of windows
        FRAME.protocol("WM_DELETE_WINDOW", self.showDialog)

    def showDialog(self):
        frame2 = tk.Toplevel(self.parentWindow)
        Dialog(frame2)


class Dialog():
    """
    This class is a subwindow from the main GUI
    """
    def __init__(self, dialogWindow):
        self.dialogWindow = dialogWindow
        self.dialogWindow.geometry("225x125")
        self.dialogWindow.resizable(tk.FALSE, tk.FALSE)
        self.dialogWindow.title("Exit")

        self.label = tk.Label(self.dialogWindow, text="Do you really want to exit?")
        self.label.place(x=50, y=20)

        self.buttonYes = tk.Button(self.dialogWindow, text="Yes", command=FRAME.destroy)
        self.buttonYes.place(x=60, y=90, width=50)

        self.buttonNo = tk.Button(self.dialogWindow, text="No", command=self.dialogWindow.destroy)
        self.buttonNo.place(x=130, y=90, width=50)


def readPathOfFiles():
    """
    Reads the path which is selected by the user
    """
    global PATH
    # return the login name of the user
    userName = getpass.getuser()
    initDir = "C:/Users/{}".format(userName)
    if os.path.exists(initDir):
        PATH = tkFileDialog.askdirectory(initialdir=initDir)
    else:
        PATH = tkFileDialog.askdirectory()
    # delete the current texfield line and add the new one which was chosen
    if PATH:
        mainWindow.textfieldPath.delete(0, tk.END)
    # read filename in textfield to make it available for the user.
    mainWindow.textfieldPath.insert(tk.END, PATH)

def loadFilesFromFolder():
    """
    Loads all files of the selected folder
    """
    # Need to test the PATH, if it is correct or not
    if PATH == None or not os.listdir(PATH):
        mb.showwarning("No file found", 
                       "This isn't an appropriate PATH. \n Please select a PATH containing a folder with .srt files.")
    else: 
        srt_files = []
        filenames = []
        # read the folder with .srt files which is selected by the user
        for filename in sorted(os.listdir(PATH)):
            if not filename.endswith('.srt') or filename == SEQUENCE_SRTFILE:
                continue

            filenames.append(os.path.splitext(filename)[0])
            pathOfFilename = os.path.join(PATH, filename)
            if os.path.isfile(pathOfFilename):
                srt_file = open(pathOfFilename, mode="r")
                srt_files.append(srt_file)

        return srt_files, filenames

def loadSequenceFile():
    """
    Loads the sequence file if it was found and return the file
    """
    if PATH:
        sequence_fname = PATH + os.sep + SEQUENCE_SRTFILE
        if not os.path.isfile(sequence_fname):
            title = "File not found"
            msg = "Expected sequence file in {}.\n".format(PATH)
            msg += "Please select a PATH containing a file called '{}'.".format(SEQUENCE_SRTFILE)
            msg += "\n You tried {}".format(sequence_fname)
            mb.showwarning(title, msg)

        else:
            return open(sequence_fname, mode="r")
    else:
        mb.showwarning("No path selected", "Please select a path to continue.")

def readSubtitleFiles():
    """
    Reads the main subtitle files which are opened to transfer the relevant data to the function class
    """
    sequence_file = loadSequenceFile()
    newline_minutes = mainWindow.textfieldMinute.get()
    # check if path and number of minutes are selected by the user
    if sequence_file is not None and newline_minutes:
    # load timeframes for sequence annotation.
        timeframesOfSequence = av.parseSrtFiles([sequence_file])[0] # just one entry
        srt_files, filenames = loadFilesFromFolder()
        timeframesOfFiles = av.parseSrtFiles(srt_files)

        FRAME.destroy()
        outdir = os.path.dirname(srt_files[0].name)
        print("Please wait...")
        if newline_minutes == "0" or len(newline_minutes) == 0:
            av.plotSubtitleData(timeframesOfFiles, timeframesOfSequence,
                                filenames, "false", outdir)
        else:
            av.plotSubtitleData(timeframesOfFiles, timeframesOfSequence,
                                filenames, newline_minutes, outdir)



def main():
    """
    Represents main function to show the usable GUI
    """
    global mainWindow
    mainWindow = ParentGUI(FRAME)
    FRAME.mainloop()

if __name__=='__main__':
    main()
